/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * Implementation of shared segment for GPFS daemon and GPFS kernel code.
 *
 * Contents:
 *
 * $Id: ss_i386.c,v 1.23 2001/09/22 20:09:39 dcraft Exp $
 *
 * $Log: ss_i386.c,v $
 * Revision 1.23  2001/09/22 20:09:39  dcraft
 * Remove kiobufs from cxiKernelIODescriptor_t.  Use temporary
 * kiobufs for map/unmap.   Remove dead code and dead comments
 * in portability layer and update readmes and license.
 * Fix traceback to appear in mmfs.log file.
 *
 * Revision 1.22  2001/09/21 22:54:56  yuri
 * Remove core dump code.
 *
 * Revision 1.21  2001/09/19 23:40:19  eshel
 * Add privilege level support for linux ia64.
 *
 * Revision 1.20  2001/08/09 21:11:38  dcraft
 * Modifications to allow running on latest Redhat 7.1 update
 * Kernel version 2.4.3-12.
 * Requires checkout of new site.mcr.proto
 *
 * Revision 1.19  2001/04/21 01:04:43  wyllie
 * Use new infrastructure for allocating and making accessible memory shared
 * between the kernel and the daemon.
 *
 * Revision 1.18  2001/04/10 21:10:57  wyllie
 * Convert cxiIOBuffer.C from C++ to C.
 *
 * Revision 1.17  2001/03/28 05:14:39  schmuck
 * Tweak some trace levels.
 *
 * Revision 1.16  2001/03/20 22:59:13  eshel
 * Add option to kxSaveThreadInfo() to get regs.
 *
 * Revision 1.15  2001/03/14 18:34:22  eshel
 * add debug information
 *
 * Revision 1.14  2001/03/06 21:55:33  dcraft
 * Minor compatible mod for building against linux-2.4.2-ac12
 *
 * Revision 1.13  2001/02/26 17:33:26  dcraft
 * Pare down unused code pieces.  Run cindent.
 *
 * Revision 1.12  2001/01/28 20:43:09  dcraft
 * Invoke lcrash for kernel thread tracebacks.  Mod kxDumpTraceBack()
 * to allow a file name for output.  Normal ksymoops is backup if
 * lcrash isn't present.
 *
 * Revision 1.11  2001/01/13 00:04:43  dcraft
 * Changes for Redhat 7.0 and 2.4.0 kernel
 *
 * Revision 1.10  2000/12/20 22:19:32  gjertsen
 * Update copyright.
 *
 * Revision 1.9  2000/12/15 13:57:00  gjertsen
 * Clean up documentation.
 *
 * Revision 1.8  2000/12/05 19:12:51  eshel
 * Add code for core dump on ia64.
 *
 * Revision 1.7  2000/11/30 22:11:39  eshel
 * Add and move code for ia64.
 *
 * Revision 1.6  2000/11/29 04:38:26  eshel
 * Add code to get thread traceback from a core file.
 *
 * Revision 1.5  2000/11/17 15:21:41  gjertsen
 * Rename or make static several functions.
 *
 * Revision 1.4  2000/11/09 01:32:04  eshel
 * Move more code to common routines for ia64 and i386.
 *
 * Revision 1.3  2000/11/08 00:51:19  eshel
 * Fix ia64 compile.
 *
 * Revision 1.2  2000/11/07 23:01:41  eshel
 * Move more common code to ss.c.
 *
 * Revision 1.1  2000/11/07 18:43:51  eshel
 * Start moving common code from ia64/ss.c and i386/ss.c to parent directory.
 *
 */

#include <Shark-gpl.h>
#include <linux/types.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/errno.h>
#include <linux/slab.h>
#include <linux/smp_lock.h>
#include <linux/proc_fs.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/file.h>
#include <linux/binfmts.h>
#include <linux/signal.h>
#include <linux/locks.h>
#include <linux/vmalloc.h>

#include <asm/pgtable.h>
#include <asm/pgalloc.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include <asm/user.h>
#include <asm/mman.h>
#include <asm/atomic.h>
#include <asm/ptrace.h>

#include <arch-gpl.h>

/*
 * Function spec: 
 *
 * Return a user_regs_struct <sys/user.h> for a particular thread
 *
 * For a particular task id, cycle thru each task via 
 *   for_each_task(task_id) 
 *
 * Look for the requested thread
 *   task_structP->pid
 *
 * A couple of the registers are found within the thread sub structure
 * pointed to by the task structure.
 *   task_structP->thread.fs
 *   task_structP->thread.gs	
 *
 * All the other regs are found via the stack pointer thread.esp0
 * The stack pointer points at the last element in a 
 * struct pt_regs <linux/ptrace.h>.  The elements of the pt_regs 
 * grow down from the stack pointer offset.
 * 
 *               Thus if thread.esp0 is 0xC0000000
 *                     pt_regs.ss       0xBFFFFFFC
 *                     pt_regs.esp      0xBFFFFFF8
 *                     pt_regs.eflags   0xBFFFFFF4
 *                     pt_regs.xcs      0xBFFFFFF0
 *                     pt_regs.eip      0xBFFFFFEC
 *                     pt_regs.orig_eax 0xBFFFFFE8
 *                     pt_regs.xes      0xBFFFFFE4
 *                     pt_regs.xds      0xBFFFFFE0
 *                     pt_regs.eax      0xBFFFFFDC
 *                     pt_regs.ebp      0xBFFFFFD8
 *                     pt_regs.edi      0xBFFFFFD4
 *                     pt_regs.esi      0xBFFFFFD0
 *                     pt_regs.edx      0xBFFFFFCC
 *                     pt_regs.ecx      0xBFFFFFC8
 *                     pt_regs.ebx      0xBFFFFFC4
 */

int
kxSaveThreadInfo(int tid, void* regP)
{
  struct task_struct *t;
  unsigned char *stackP;
  int rc = ENOENT;
  union
  {
    struct user_regs_struct userRegs;
    unsigned long regArray[0];
  } u;

#define STACKP(A) (*(unsigned long *)(stackP - \
                     (unsigned char *)(sizeof(struct pt_regs) - \
                                       (long)&((struct pt_regs *)0)->A)))
#define REGARRAY(A)  \
          u.regArray[(long)&(((struct user_regs_struct *)0)->A) / sizeof(long)]

  for_each_task(t)
  {
    if (t->pid != tid)
      continue;

    REGARRAY(fs) = t->thread.fs;
    REGARRAY(gs) = t->thread.gs;

    stackP = (char *)t->thread.esp0;

    REGARRAY(ss)       = STACKP(xss);
    REGARRAY(esp)      = STACKP(esp);
    REGARRAY(eflags)   = STACKP(eflags);
    REGARRAY(cs)       = STACKP(xcs);
    REGARRAY(eip)      = STACKP(eip);
    REGARRAY(orig_eax) = STACKP(orig_eax);
    REGARRAY(es)       = STACKP(xes);
    REGARRAY(ds)       = STACKP(xds);
    REGARRAY(eax)      = STACKP(eax);
    REGARRAY(ebp)      = STACKP(ebp);
    REGARRAY(edi)      = STACKP(edi);
    REGARRAY(esi)      = STACKP(esi);
    REGARRAY(edx)      = STACKP(edx);
    REGARRAY(ecx)      = STACKP(ecx);
    REGARRAY(ebx)      = STACKP(ebx);

    rc = 0;
    break;
  }

  if (rc == 0)
    copy_to_user(regP, &u.userRegs, sizeof(struct user_regs_struct));
  return rc;
} 	

int
set_privilege_level(unsigned long progLevel)
{
  return 0;
}

int
get_privilege_level()
{
  return 0;
}
